package gov.va.med.mhv.usermgmt.web.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.usermgmt.service.UserMgmtService;
import gov.va.med.mhv.usermgmt.web.converter.EmergencyContactConverter;
import gov.va.med.mhv.usermgmt.web.converter.EmergencyContactDTOConverter;
import gov.va.med.mhv.usermgmt.web.formbean.EmergencyContact;
import gov.va.med.mhv.usermgmt.web.formbean.UserProfileSession;
import gov.va.med.mhv.usermgmt.web.util.EmergencyContactCompare;

@ManagedBean
@RequestScoped
public class EmergencyContactListController implements Serializable {
	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(EmergencyContactListController.class);
	
	private static String GENERAL_ERROR = "An unknown exception occurred.";
	private static String DELETE_SUCCESS = "You have removed your primary contact.";

	@ManagedProperty("#{emergencyContactConverter}")
	private EmergencyContactConverter emergencyContactConverter;
	
	@ManagedProperty("#{emergencyContactDTOConverter}")
	private EmergencyContactDTOConverter emergencyContactDTOConverter;

	@ManagedProperty("#{userMgmtServiceProxy}")
	private UserMgmtService userMgmtServiceProxy;
	
	@ManagedProperty("#{userProfileSession}")
	private UserProfileSession userProfileSession;

	private List<EmergencyContact> emergencyContacts = new ArrayList<EmergencyContact>();
			
	@PostConstruct
	public void init() {
		log.debug("@PostConstruct");
		loadModel();
	}

	public void loadModel() {
		log.debug("loadModel");

		try {
			emergencyContacts.clear();
			
			log.debug("userProfileId=" + userProfileSession.getUserProfileId());

			List<EmergencyContactDTO> list = userMgmtServiceProxy.getEmergencyContacts(userProfileSession.getUserProfileId());
			
			if (list != null) {
				for (EmergencyContactDTO dto : list) {
					EmergencyContact ec = emergencyContactConverter.convert(dto);
					emergencyContacts.add(ec);
				}
				
				Collections.sort(emergencyContacts, new EmergencyContactCompare());
			}
			
		} catch (Exception e) {
			log.error(e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, GENERAL_ERROR, GENERAL_ERROR));
		}
	}

	public void deleteContact(EmergencyContact ec) {
		log.debug("deleteContact");

		try {

			log.debug("Deleting contact emergencyContactId=" + ec.getEmergencyContactId());
			EmergencyContactDTO dto = emergencyContactDTOConverter.convert(ec);
			userMgmtServiceProxy.deleteEmergencyContact(dto);
			log.debug("delete - success");
			
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, DELETE_SUCCESS, DELETE_SUCCESS));
			
			loadModel();

		} catch (Exception e) {
			log.debug("delete - fail");
			log.error(e);
			FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, GENERAL_ERROR, GENERAL_ERROR));
		}
	}

	public EmergencyContactConverter getEmergencyContactConverter() {
		return emergencyContactConverter;
	}

	public void setEmergencyContactConverter(EmergencyContactConverter emergencyContactConverter) {
		this.emergencyContactConverter = emergencyContactConverter;
	}

	public EmergencyContactDTOConverter getEmergencyContactDTOConverter() {
		return emergencyContactDTOConverter;
	}

	public void setEmergencyContactDTOConverter(EmergencyContactDTOConverter emergencyContactDTOConverter) {
		this.emergencyContactDTOConverter = emergencyContactDTOConverter;
	}

	public UserMgmtService getUserMgmtServiceProxy() {
		return userMgmtServiceProxy;
	}

	public void setUserMgmtServiceProxy(UserMgmtService userMgmtServiceProxy) {
		this.userMgmtServiceProxy = userMgmtServiceProxy;
	}

	public UserProfileSession getUserProfileSession() {
		return userProfileSession;
	}

	public void setUserProfileSession(UserProfileSession userProfileSession) {
		this.userProfileSession = userProfileSession;
	}

	public List<EmergencyContact> getEmergencyContacts() {
		return emergencyContacts;
	}

	public void setEmergencyContacts(List<EmergencyContact> emergencyContacts) {
		this.emergencyContacts = emergencyContacts;
	}
}
